/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator;

import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.engine.screen.animator.Animator;
import lib.toma.animations.engine.screen.animator.AnimatorFrameProvider;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.screen.animator.FrameProviderWrapper;
import lib.toma.animations.engine.screen.animator.ImportProjectScreen;
import lib.toma.animations.engine.screen.animator.dialog.DialogScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SetBackgroundAnimationScreen
extends ImportProjectScreen {
    private static final ITextComponent SET = new StringTextComponent("Set");
    private static final ITextComponent DELETE = new StringTextComponent("Unset");
    private final IBackgroundAnimationSetter setter;

    public SetBackgroundAnimationScreen(AnimatorScreen screen, ImportProjectScreen.IBackgroundAnimationUnsetter unsetter, IBackgroundAnimationSetter setter) {
        super(screen, unsetter);
        this.setter = setter;
    }

    @Override
    protected void placeControlButtons(int totalButtonWidth, int buttonWidth) {
        int componentAreaWidth = this.field_230708_k_ - 20;
        int componentWidth = componentAreaWidth / 3;
        int y = this.field_230709_l_ - 25;
        this.confirm = (Button)this.func_230480_a_((Widget)new Button(5, y, componentWidth, 20, SET, this::confirmClicked));
        Button delete = (Button)this.func_230480_a_((Widget)new Button(11 + componentWidth, y, componentWidth, 20, DELETE, this::deleteClicked));
        this.cancel = (Button)this.func_230480_a_((Widget)new Button(17 + 2 * componentWidth, y, componentWidth, 20, DialogScreen.CANCEL, this::cancelClicked));
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        delete.field_230693_o_ = pipeline.has(Animator.BACKGROUND_TYPE);
    }

    @Override
    protected void confirmClicked(Button button) {
        Animator animator = Animator.get();
        String path = this.getSelectedPath();
        FrameProviderWrapper wrapper = animator.getWrapper(path);
        AnimatorFrameProvider provider = wrapper.getProvider();
        this.setter.setBackgroundAnimation(provider);
        this.showParent();
    }

    private void deleteClicked(Button button) {
        this.unsetBackgroundAnimation();
        this.showParent();
    }

    @FunctionalInterface
    public static interface IBackgroundAnimationSetter {
        public void setBackgroundAnimation(IKeyframeProvider var1);
    }
}

